package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.FacilityDTO;
import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.PatientRegistryChangeDTO;
import gov.va.med.mhv.common.data.converter.FacilityConverter;
import gov.va.med.mhv.common.data.converter.InPersonAuthenticationConverter;
import gov.va.med.mhv.admin.converter.PatientRegistryChangeLocalConverter;
import gov.va.med.mhv.common.data.model.Facility;
import gov.va.med.mhv.common.data.model.InPersonAuthentication;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.common.data.model.PatientRegistryChange;
import gov.va.med.mhv.common.data.model.UserProfile;

@Component
public class PatientLocalConverter {

	@Autowired
	private FacilityConverter facilityConverter;

	@Autowired
	private PatientRegistryChangeLocalConverter patientRegChangeConverter;

	@Autowired
	InPersonAuthenticationConverter inPersonAuthenticationConverter;

	@Autowired
	UserProfileLocalConverter userProfileConverter;

	public PatientDTO convertDomainPatient(Patient patient) {
		PatientDTO patientDto = new PatientDTO();

		patientDto.setId(patient.getId());
		patientDto.setOplock(patient.getOplock());
		patientDto.setInvalidationReferenceId(patient.getInvalidationReferenceId());
		patientDto.setLastFacilitiesUpdateDateTime(patient.getLastFacilitiesUpdateDateTime());
		patientDto.setIcn(patient.getIcn());
		patientDto.setCorrelationErrorCode(patient.getCorrelationErrorCode());
		patientDto.setMatchedDateTime(patient.getMatchedDateTime());
		patientDto.setCorrelateRequestDateTime(patient.getCorrelateRequestDateTime());
		patientDto.setInvalidatedIcn(patient.getInvalidatedIcn());
		patientDto.setCorrelatedDateTime(patient.getCorrelatedDateTime());
		patientDto.setCorrelationStatus(patient.getCorrelationStatus());
		patientDto.setCorrelatedBy(patient.getCorrelatedBy());

		try {
			if (null != patient.getFacilities() && patient.getFacilities().size() > 0) {
				Set<FacilityDTO> facilitieDtos = new HashSet<FacilityDTO>();
				for (Facility facility : patient.getFacilities()) {
					facilitieDtos.add(facilityConverter.convertDomainFacility(facility));
				}
				patientDto.setFacilities(facilitieDtos);
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}
		if (null != patient.getPatientRegistryChanges() && patient.getPatientRegistryChanges().size() > 0) {
			Set<PatientRegistryChangeDTO> regChangeDtos = new HashSet<PatientRegistryChangeDTO>();
			for (PatientRegistryChange regChange : patient.getPatientRegistryChanges()) {
				regChangeDtos.add(patientRegChangeConverter.convertDomainPatientRegistryChange(regChange));
			}
			patientDto.setPatientRegistryChanges(regChangeDtos);
		}

		patientDto.setIpas(getIpaDTOS(patient.getIpas(), patientDto));

		patientDto.setUserProfileId(patient.getUserProfile().getId());
		if (null != patient.getUserProfile()) {
			patientDto.setUserProfile(userProfileConverter.convertDomainUserProfile(patient.getUserProfile()));
		}

		return patientDto;
	}

	public Patient convertDTOProfile(PatientDTO patientDto) {
		Patient patient = new Patient();
		if (patientDto != null && patientDto.getCorrelatedBy() != null) {
			patient.setCorrelatedBy(patientDto.getCorrelatedBy());
		}
		if (patientDto != null && patientDto.getCorrelatedDateTime() != null)
			patient.setCorrelatedDateTime(patientDto.getCorrelatedDateTime());
		if (patientDto != null && patientDto.getCorrelateRequestDateTime() != null)
			patient.setCorrelateRequestDateTime(patientDto.getCorrelateRequestDateTime());
		if (patientDto != null && patientDto.getCorrelationErrorCode() != null)
			patient.setCorrelationErrorCode(patientDto.getCorrelationErrorCode());
		if (patientDto != null && patientDto.getCorrelationStatus() != null)
			patient.setCorrelationStatus(patientDto.getCorrelationStatus());
		if (patientDto != null && patientDto.getIcn() != null)
			patient.setIcn(patientDto.getIcn());
		if (patientDto != null && patientDto.getId() != null)
			patient.setId(patientDto.getId());
		if (patientDto != null && patientDto.getInvalidatedIcn() != null)
			patient.setInvalidatedIcn(patientDto.getInvalidatedIcn());
		if (patientDto != null && patientDto.getInvalidationReferenceId() != null)
			patient.setInvalidationReferenceId(patientDto.getInvalidationReferenceId());
		if (patientDto != null && patientDto.getLastFacilitiesUpdateDateTime() != null)
			patient.setLastFacilitiesUpdateDateTime(patientDto.getLastFacilitiesUpdateDateTime());
		if (patientDto != null && patientDto.getMatchedDateTime() != null)
			patient.setMatchedDateTime(patientDto.getMatchedDateTime());
		if (patientDto != null && patientDto.getOplock() != null) {
			patient.setOplock(patientDto.getOplock());
		} else {
			patient.setOplock(20);
		}
		if (patientDto != null && patientDto.getIpas() != null)
			patient.setIpas(getIpas(patientDto.getIpas()));
		if (patientDto != null && patientDto.getUserProfileId() != null)
			patient.setUserProfileId(patientDto.getUserProfileId());

		if (patientDto != null && null != patientDto.getUserProfile()) {
			patient.setUserProfile(
					userProfileConverter.convertDTOProfile(new UserProfile(), patientDto.getUserProfile()));
		}

		try {
			if (patientDto != null && null != patientDto.getFacilities() && patientDto.getFacilities().size() > 0) {
				Set<Facility> facilities = new HashSet<Facility>();
				for (FacilityDTO facility : patientDto.getFacilities()) {
					facilities.add(facilityConverter.coonvertDTOFacility(facility));
				}
				patient.setFacilities(facilities);
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}
		
		if (patientDto != null && null != patientDto.getPatientRegistryChanges()
				&& patientDto.getPatientRegistryChanges().size() > 0) {
			Set<PatientRegistryChange> regChanges = new HashSet<PatientRegistryChange>();
			for (PatientRegistryChangeDTO regChangeDto : patientDto.getPatientRegistryChanges()) {
				regChanges.add(patientRegChangeConverter.convertDTOPatientRegistryChange(regChangeDto));
			}
			patient.setPatientRegistryChanges(regChanges);
		}		

		return patient;
	}

	private Set<InPersonAuthenticationDTO> getIpaDTOS(Set<InPersonAuthentication> ipas, PatientDTO patientDTO) {
		Set<InPersonAuthenticationDTO> ipaDtos = new HashSet<InPersonAuthenticationDTO>();
		if (ipas != null) {
			for (InPersonAuthentication ipa : ipas) {
				InPersonAuthenticationDTO ipaDto = inPersonAuthenticationConverter
						.convertDomainInpersonAuthentication(ipa);
				if (null != ipaDto) {
					ipaDtos.add(ipaDto);
				}
			}
		}
		return ipaDtos;
	}

	private Set<InPersonAuthentication> getIpas(Set<InPersonAuthenticationDTO> ipaDTOs) {
		Set<InPersonAuthentication> ipas = new HashSet<InPersonAuthentication>();
		if (ipaDTOs != null) {
			for (InPersonAuthenticationDTO ipaDto : ipaDTOs) {
				InPersonAuthentication ipa = inPersonAuthenticationConverter.convertInpersonAuthenticationDTO(ipaDto);
				// add patient's info to IPA
				inPersonAuthenticationConverter.addPatientProfile(ipaDto, ipa);

				if (null != ipa) {
					ipas.add(ipa);
				}
			}
		}
		return ipas;
	}

	public List<PatientDTO> convertList(List<Patient> source) {

		List<PatientDTO> destination = new ArrayList<PatientDTO>();
		for (Patient a : source) {
			destination.add(convertDomainPatient(a));
		}
		return destination;
	}
}
